/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class SelectDeviceScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_audio_devices.png");
    protected static final Component BACK = Component.translatable((String)"message.voicechat.back");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    @Nullable
    protected Screen parent;
    protected AudioDeviceList deviceList;
    protected Button back;
    protected int units;

    public SelectDeviceScreen(Component title, @Nullable Screen parent) {
        super(title, 236, 0);
        this.parent = parent;
    }

    public abstract List<String> getDevices();

    public abstract Component getEmptyListComponent();

    public abstract AudioDeviceList createAudioDeviceList(int var1, int var2, int var3);

    @Override
    protected void init() {
        super.init();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.ceil((float)2.2222223f);
        this.units = Math.max(minUnits, (this.height - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.deviceList != null) {
            this.deviceList.setRectangle(this.width, this.units * 18, 0, this.guiTop + 16);
        } else {
            this.deviceList = this.createAudioDeviceList(this.width, this.units * 18, this.guiTop + 16);
        }
        this.addWidget((GuiEventListener)this.deviceList);
        this.back = Button.builder((Component)BACK, button -> this.minecraft.setScreen(this.parent)).bounds(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20).build();
        this.addRenderableWidget((GuiEventListener)this.back);
        this.deviceList.setAudioDevices(this.getDevices());
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
            for (int i = 0; i < this.units; ++i) {
                guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
            }
            guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
            guiGraphics.blit(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.guiTop + 5, this.isIngame() ? 0x404040 : ChatFormatting.WHITE.getColor(), false);
        if (!this.deviceList.isEmpty()) {
            this.deviceList.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            Component component = this.getEmptyListComponent();
            int n = this.width / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, component, n, n2 - 9 / 2, -1);
        }
    }
}

